function LRSimilarities(simMat)
% build list of L/R pairs
[S labels] = getMatrix(simMat);
pairs = {};
for i = 1:numel(labels)
    if matchregexp(labels{i},'^.{3,}[LR]$')
        tmp = labels{i};
        tmp = tmp(1:(end-1));
        if ~ismember(tmp,pairs)
            pairs = [pairs; tmp];
        end
        
        % need a separate case to handle names like 'vBWML23' and 'dglL3'
    elseif matchregexp(labels{i},'^[vd]BWM[LR][\d]+$')
        tmp = labels{i};
        tmp = tmp([1:4 6:end]);
        if ~ismember(tmp,pairs)
            pairs = [pairs; tmp];
        end
    elseif matchregexp(labels{i},'^dgl[LR][\d]+$')
        tmp = labels{i};
        tmp = tmp([1:3 5:end]);
        if ~ismember(tmp,pairs)
            pairs = [pairs; tmp];
        end
    end
    
end


% disp(pairs)
pairsMat = zeros(numel(pairs),1);
for i = 1:numel(pairs)
    try
        if matchregexp(pairs{i},'^[vd]BWM[\d]+$')
            tmp = pairs{i};
            pairsMat(i) = simMat([tmp([1:4]) 'L' tmp([5:end])], [tmp([1:4]) 'R' tmp([5:end])]);
            continue;
        elseif matchregexp(pairs{i},'^dgl[\d]+$')
            tmp = pairs{i};
            pairsMat(i) = simMat([tmp(1:3) 'L' tmp(4:end)], [tmp(1:3) 'R' tmp(4:end)]);
            continue;
        end
        pairsMat(i) = simMat([pairs{i} 'L'],[pairs{i} 'R']);
    catch exception
        pairsMat(i) = NaN;
    end
end

pairs(isnan(pairsMat)) = [];
pairsMat(isnan(pairsMat)) = [];
hist(pairsMat)
[vals idxs] = sort(pairsMat,'descend');

for i = 1:numel(pairs)
    if matchregexp(pairs{idxs(i)},'^[vd]BWM[\d]+$')
        tmp = pairs{idxs(i)};
        fprintf('%-30s\t%.5f\n',[tmp(1:4) 'L' tmp(5:end) ',' tmp(1:4) 'R' tmp(5:end)],vals(i));
        continue;
    elseif matchregexp(pairs{i},'^dgl[\d]+$')
        tmp = pairs{idxs(i)};
        fprintf('%-30s\t%.5f\n',[tmp(1:3) 'L' tmp(4:end) ',' tmp(1:3) 'R' tmp(4:end)],vals(i));
        continue;
    end
    fprintf('%-30s\t%.5f\n',[pairs{idxs(i)} 'L,',pairs{idxs(i)} 'R'],vals(i));
end


end


